/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.NutationCodec;
import org.orekit.data.PolynomialNutation;
import org.orekit.data.SeriesTerm;

public class PoissonSeries<T extends RealFieldElement<T>> {
    private final PolynomialNutation<T> polynomial;
    private final Map<Long, SeriesTerm<T>> series;

    public PoissonSeries(PolynomialNutation<T> polynomial, Map<Long, SeriesTerm<T>> series) {
        this.polynomial = polynomial;
        this.series = series;
    }

    public PolynomialNutation<T> getPolynomial() {
        return this.polynomial;
    }

    public int getNonPolynomialSize() {
        return this.series.size();
    }

    public double value(BodiesElements elements) {
        double p = this.polynomial.value(elements.getTC());
        double npHigh = 0.0;
        double npLow = 0.0;
        for (SeriesTerm<T> term : this.series.values()) {
            double v = term.value(elements)[0];
            double sum = npHigh + v;
            double sPrime = sum - v;
            double tPrime = sum - sPrime;
            double deltaS = npHigh - sPrime;
            double deltaT = v - tPrime;
            npLow += deltaS + deltaT;
            npHigh = sum;
        }
        return p + (npHigh + npLow);
    }

    public T value(FieldBodiesElements<T> elements) {
        Object tc = elements.getTC();
        T p = this.polynomial.value(tc);
        RealFieldElement sum = (RealFieldElement)tc.getField().getZero();
        for (SeriesTerm<T> term : this.series.values()) {
            sum = (RealFieldElement)sum.add((Object)term.value(elements)[0]);
        }
        return (T)((RealFieldElement)p.add((Object)sum));
    }

    public static <S extends RealFieldElement<S>> CompiledSeries<S> compile(PoissonSeries<S> ... poissonSeries) {
        final PolynomialNutation[] polynomials = (PolynomialNutation[])Array.newInstance(PolynomialNutation.class, poissonSeries.length);
        for (int i = 0; i < polynomials.length; ++i) {
            polynomials[i] = poissonSeries[i].polynomial;
        }
        HashMap joinedMap = new HashMap();
        for (PoissonSeries<S> ps : poissonSeries) {
            for (long key : ps.series.keySet()) {
                if (joinedMap.containsKey(key)) continue;
                int[] m = NutationCodec.decode(key);
                SeriesTerm term = SeriesTerm.buildTerm(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11], m[12], m[13], m[14]);
                term.add(poissonSeries.length - 1, -1, Double.NaN, Double.NaN);
                joinedMap.put(key, term);
            }
        }
        for (int i = 0; i < poissonSeries.length; ++i) {
            for (Map.Entry entry : poissonSeries[i].series.entrySet()) {
                SeriesTerm singleTerm = entry.getValue();
                SeriesTerm joinedTerm = (SeriesTerm)joinedMap.get(entry.getKey());
                for (int degree = 0; degree <= singleTerm.getDegree(0); ++degree) {
                    joinedTerm.add(i, degree, singleTerm.getSinCoeff(0, degree), singleTerm.getCosCoeff(0, degree));
                }
            }
        }
        final SeriesTerm[] joinedTerms = joinedMap.values().toArray((SeriesTerm[])Array.newInstance(SeriesTerm.class, joinedMap.size()));
        return new CompiledSeries<S>(){

            @Override
            public double[] value(BodiesElements elements) {
                double[] npHigh = new double[polynomials.length];
                double[] npLow = new double[polynomials.length];
                for (SeriesTerm term : joinedTerms) {
                    double[] termValue = term.value(elements);
                    for (int i = 0; i < termValue.length; ++i) {
                        double v = termValue[i];
                        double sum = npHigh[i] + v;
                        double sPrime = sum - v;
                        double tPrime = sum - sPrime;
                        double deltaS = npHigh[i] - sPrime;
                        double deltaT = v - tPrime;
                        int n = i;
                        npLow[n] = npLow[n] + (deltaS + deltaT);
                        npHigh[i] = sum;
                    }
                }
                for (int i = 0; i < npHigh.length; ++i) {
                    int n = i;
                    npHigh[n] = npHigh[n] + (npLow[i] + polynomials[i].value(elements.getTC()));
                }
                return npHigh;
            }

            @Override
            public S[] value(FieldBodiesElements<S> elements) {
                RealFieldElement[] v = (RealFieldElement[])MathArrays.buildArray((Field)elements.getTC().getField(), (int)polynomials.length);
                for (SeriesTerm term : joinedTerms) {
                    RealFieldElement[] termValue = term.value(elements);
                    for (int i = 0; i < termValue.length; ++i) {
                        v[i] = (RealFieldElement)v[i].add((Object)termValue[i]);
                    }
                }
                Object tc = elements.getTC();
                for (int i = 0; i < v.length; ++i) {
                    v[i] = (RealFieldElement)v[i].add(polynomials[i].value(tc));
                }
                return v;
            }
        };
    }

    public static interface CompiledSeries<S extends RealFieldElement<S>> {
        public double[] value(BodiesElements var1);

        public S[] value(FieldBodiesElements<S> var1);
    }
}

