/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.orekit.errors.OrekitException;

class NutationCodec {
    private long flag = 1L;
    private int shift = 15;
    private long key;

    private NutationCodec(long key) {
        this.key = key;
    }

    public long getKey() {
        return this.key;
    }

    private void addMultiplier(int multiplier) {
        if (multiplier != 0) {
            this.key |= this.flag;
            if (this.shift > 57 || multiplier < -64 || multiplier > 63) {
                throw OrekitException.createInternalError(null);
            }
            this.key |= ((long)multiplier + 64L & 0x7FL) << this.shift;
            this.shift += 7;
        }
        this.flag <<= 1;
    }

    private int nextMultiplier() {
        int multiplier;
        if ((this.key & this.flag) == 0L) {
            multiplier = 0;
        } else {
            multiplier = (int)(this.key >>> this.shift & 0x7FL) - 64;
            this.shift += 7;
        }
        this.flag <<= 1;
        return multiplier;
    }

    public static long encode(int ... multipliers) {
        NutationCodec encoder = new NutationCodec(0L);
        for (int multiplier : multipliers) {
            encoder.addMultiplier(multiplier);
        }
        return encoder.getKey();
    }

    public static int[] decode(long key) {
        int[] multipliers = new int[15];
        NutationCodec decoder = new NutationCodec(key);
        for (int i = 0; i < multipliers.length; ++i) {
            multipliers[i] = decoder.nextMultiplier();
        }
        return multipliers;
    }
}

