/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class TabulatedProvider
implements AttitudeProvider {
    private static final long serialVersionUID = 20140723L;
    private final Frame referenceFrame;
    private final transient ImmutableTimeStampedCache<TimeStampedAngularCoordinates> table;
    private final AngularDerivativesFilter filter;

    @Deprecated
    public TabulatedProvider(List<Attitude> table, int n, boolean useRotationRate) {
        this(table.get(0).getReferenceFrame(), TabulatedProvider.toTimeStampedAngularCoordinates(table), n, useRotationRate ? AngularDerivativesFilter.USE_RR : AngularDerivativesFilter.USE_R);
    }

    public TabulatedProvider(Frame referenceFrame, List<TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter) {
        this.referenceFrame = referenceFrame;
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(n, table);
        this.filter = filter;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        List<TimeStampedAngularCoordinates> sample = this.table.getNeighbors(date);
        TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, this.filter, sample);
        return new Attitude(this.referenceFrame, interpolated);
    }

    private static List<TimeStampedAngularCoordinates> toTimeStampedAngularCoordinates(List<Attitude> attitudes) {
        ArrayList<TimeStampedAngularCoordinates> converted = new ArrayList<TimeStampedAngularCoordinates>(attitudes.size());
        for (Attitude attitude : attitudes) {
            converted.add(attitude.getOrientation());
        }
        return converted;
    }

    private Object writeReplace() throws NotSerializableException {
        return new DataTransferObject(this.referenceFrame, this.table.getAll(), this.table.getNeighborsSize(), this.filter);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private final Frame referenceFrame;
        private final List<TimeStampedAngularCoordinates> list;
        private final int n;
        private final AngularDerivativesFilter filter;

        public DataTransferObject(Frame referenceFrame, List<TimeStampedAngularCoordinates> list, int n, AngularDerivativesFilter filter) {
            this.referenceFrame = referenceFrame;
            this.list = list;
            this.n = n;
            this.filter = filter;
        }

        private Object readResolve() {
            return new TabulatedProvider(this.referenceFrame, this.list, this.n, this.filter);
        }
    }
}

