/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class LofOffsetPointing
extends GroundPointing {
    private static final long serialVersionUID = 20140811L;
    private final AttitudeProvider attitudeLaw;
    private final BodyShape shape;
    private final Vector3D satPointingVector;

    public LofOffsetPointing(BodyShape shape, AttitudeProvider attLaw, Vector3D satPointingVector) {
        super(shape.getBodyFrame());
        this.shape = shape;
        this.attitudeLaw = attLaw;
        this.satPointingVector = satPointingVector;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.attitudeLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    protected TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform refToSc = new Transform(date, new Transform(date, pvProv.getPVCoordinates(date, frame).negate()), new Transform(date, this.attitudeLaw.getAttitude(pvProv, date, frame).getOrientation()));
        Transform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        Transform scToBody = new Transform(date, refToSc.getInverse(), refToBody);
        double h = 0.1;
        ArrayList<TimeStampedPVCoordinates> sample = new ArrayList<TimeStampedPVCoordinates>();
        sample.add(this.losIntersectionWithBody(scToBody.shiftedBy(-0.1)));
        sample.add(this.losIntersectionWithBody(scToBody));
        sample.add(this.losIntersectionWithBody(scToBody.shiftedBy(0.1)));
        TimeStampedPVCoordinates targetBody = TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
        return refToBody.getInverse().transformPVCoordinates(targetBody);
    }

    private TimeStampedPVCoordinates losIntersectionWithBody(Transform scToBody) throws OrekitException {
        Vector3D pIntersection;
        Vector3D pointingBodyFrame = scToBody.transformVector(this.satPointingVector);
        Vector3D pBodyFrame = scToBody.transformPosition(Vector3D.ZERO);
        Line pointingLine = new Line(pBodyFrame, pBodyFrame.add(6378137.0, (Vector)pointingBodyFrame), 1.0E-10);
        GeodeticPoint gpIntersection = this.shape.getIntersectionPoint(pointingLine, pBodyFrame, this.shape.getBodyFrame(), scToBody.getDate());
        Vector3D vector3D = pIntersection = gpIntersection == null ? null : this.shape.transform(gpIntersection);
        if (pIntersection == null || Vector3D.dotProduct((Vector3D)pIntersection.subtract((Vector)pBodyFrame), (Vector3D)pointingBodyFrame) < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.ATTITUDE_POINTING_LAW_DOES_NOT_POINT_TO_GROUND, new Object[0]);
        }
        return new TimeStampedPVCoordinates(scToBody.getDate(), pIntersection, Vector3D.ZERO, Vector3D.ZERO);
    }
}

